<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post\Comment;

trait TraitPostCommentSetters
{
    use TraitPostCommentProperties;

    /**
     * @return static 
     */
    final public function setId(string $id)
    {
        $this -> id = $id;

        return $this;
    }

    /**
     * @return static 
     */
    public function setOwnerUserId(string $ownerUserId)
    {
        $this -> ownerUserId = $ownerUserId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setParentPostId(string $parentPostId)
    {
        $this -> parentPostId = $parentPostId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setReplyToPostcommentId(string $replyToPostCommentId)
    {
        $this -> replyToPostCommentId = $replyToPostCommentId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setDisplayText(string $displayText)
    {
        $this -> displayText = $displayText;

        return $this;
    }

    /**
     * @return static 
     */
    public function setCacheLikesCount(string $cacheLikesCount)
    {
        $this -> cacheLikesCount = $cacheLikesCount;

        return $this;
    }

    /**
     * @return static 
     */
    public function setCacheCommentsCount(string $cacheCommentsCount)
    {
        $this -> cacheCommentsCount = $cacheCommentsCount;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampRegistration(string $stampRegistration)
    {
        $this -> stampRegistration = $stampRegistration;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampLastUpdate(string $stampLastUpdate)
    {
        $this -> stampLastUpdate = $stampLastUpdate;

        return $this;
    }
}
